// EnvelopeCtl.cpp : Implementation of the CEnvelopeCtrl ActiveX Control class.

#include "stdafx.h"
#include "envelope.h"
#include "EnvelopeCtl.h"
#include "EnvelopePpg.h"
#include "resource.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNCREATE(CEnvelopeCtrl, COleControl)

#define HANDLE_SIZE		2


/////////////////////////////////////////////////////////////////////////////
// Message map

BEGIN_MESSAGE_MAP(CEnvelopeCtrl, COleControl)
	ON_WM_CONTEXTMENU()
	//{{AFX_MSG_MAP(CEnvelopeCtrl)
	ON_WM_LBUTTONDOWN()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
	ON_COMMAND(ID_ADD_POINT, OnAddPoint)
	ON_COMMAND(ID_DELETE_POINT, OnDeletePoint)
	ON_UPDATE_COMMAND_UI(ID_DELETE_POINT, OnUpdateDeletePoint)
	ON_COMMAND(ID_SUSTAIN, OnSustain)
	ON_UPDATE_COMMAND_UI(ID_SUSTAIN, OnUpdateSustain)
	ON_COMMAND(ID_RESET, OnReset)
	ON_COMMAND(ID_INVERT, OnInvert)
	//}}AFX_MSG_MAP
	ON_OLEVERB(AFX_IDS_VERB_EDIT, OnEdit)
	ON_OLEVERB(AFX_IDS_VERB_PROPERTIES, OnProperties)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// Dispatch map

BEGIN_DISPATCH_MAP(CEnvelopeCtrl, COleControl)
	//{{AFX_DISPATCH_MAP(CEnvelopeCtrl)
	DISP_FUNCTION(CEnvelopeCtrl, "SetEnvelope", SetEnvelope, VT_EMPTY, VTS_I4 VTS_I4 VTS_PI4)
	DISP_FUNCTION(CEnvelopeCtrl, "SetPlayPosition", SetPlayPosition, VT_EMPTY, VTS_I4)
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()


/////////////////////////////////////////////////////////////////////////////
// Event map

BEGIN_EVENT_MAP(CEnvelopeCtrl, COleControl)
	//{{AFX_EVENT_MAP(CEnvelopeCtrl)
	EVENT_CUSTOM("EnvelopeChanged", FireEnvelopeChanged, VTS_I4  VTS_I4  VTS_PI4)
	//}}AFX_EVENT_MAP
END_EVENT_MAP()


/////////////////////////////////////////////////////////////////////////////
// Property pages

// TODO: Add more property pages as needed.  Remember to increase the count!
BEGIN_PROPPAGEIDS(CEnvelopeCtrl, 1)
	PROPPAGEID(CEnvelopePropPage::guid)
END_PROPPAGEIDS(CEnvelopeCtrl)


/////////////////////////////////////////////////////////////////////////////
// Initialize class factory and guid

IMPLEMENT_OLECREATE_EX(CEnvelopeCtrl, "ENVELOPE.EnvelopeCtrl.1",
	0x396d2eb7, 0x53aa, 0x11d1, 0xa1, 0xd9, 0x46, 0x76, 0xee, 0, 0, 0)


/////////////////////////////////////////////////////////////////////////////
// Type library ID and version

IMPLEMENT_OLETYPELIB(CEnvelopeCtrl, _tlid, _wVerMajor, _wVerMinor)


/////////////////////////////////////////////////////////////////////////////
// Interface IDs

const IID BASED_CODE IID_DEnvelope =
		{ 0x396d2eb5, 0x53aa, 0x11d1, { 0xa1, 0xd9, 0x46, 0x76, 0xee, 0, 0, 0 } };
const IID BASED_CODE IID_DEnvelopeEvents =
		{ 0x396d2eb6, 0x53aa, 0x11d1, { 0xa1, 0xd9, 0x46, 0x76, 0xee, 0, 0, 0 } };


/////////////////////////////////////////////////////////////////////////////
// Control type information
 
static const DWORD BASED_CODE _dwEnvelopeOleMisc =
	OLEMISC_ACTIVATEWHENVISIBLE |
	OLEMISC_SETCLIENTSITEFIRST |
	OLEMISC_INSIDEOUT |
	OLEMISC_CANTLINKINSIDE |
	OLEMISC_RECOMPOSEONRESIZE;

IMPLEMENT_OLECTLTYPE(CEnvelopeCtrl, IDS_ENVELOPE, _dwEnvelopeOleMisc)


/////////////////////////////////////////////////////////////////////////////
// CEnvelopeCtrl::CEnvelopeCtrlFactory::UpdateRegistry -
// Adds or removes system registry entries for CEnvelopeCtrl

BOOL CEnvelopeCtrl::CEnvelopeCtrlFactory::UpdateRegistry(BOOL bRegister)
{
	// TODO: Verify that your control follows apartment-model threading rules.
	// Refer to MFC TechNote 64 for more information.
	// If your control does not conform to the apartment-model rules, then
	// you must modify the code below, changing the 6th parameter from
	// afxRegInsertable | afxRegApartmentThreading to afxRegInsertable.

	if (bRegister)
		return AfxOleRegisterControlClass(
			AfxGetInstanceHandle(),
			m_clsid,
			m_lpszProgID,
			IDS_ENVELOPE,
			IDB_ENVELOPE,
			afxRegInsertable | afxRegApartmentThreading,
			_dwEnvelopeOleMisc,
			_tlid,
			_wVerMajor,
			_wVerMinor);
	else
		return AfxOleUnregisterClass(m_clsid, m_lpszProgID);
}


/////////////////////////////////////////////////////////////////////////////
// CEnvelopeCtrl::CEnvelopeCtrl - Constructor

CEnvelopeCtrl::CEnvelopeCtrl()
{
	InitializeIIDs(&IID_DEnvelope, &IID_DEnvelopeEvents);

	Reset();
}


/////////////////////////////////////////////////////////////////////////////
// CEnvelopeCtrl::~CEnvelopeCtrl - Destructor

CEnvelopeCtrl::~CEnvelopeCtrl()
{
	// TODO: Cleanup your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CEnvelopeCtrl::OnDraw - Drawing function

void CEnvelopeCtrl::OnDraw(
			CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid)
{
	ASSERT(Handles.size() >= 2);

	Bounds = rcBounds;

	pdc->FillSolidRect(rcBounds, RGB(0, 0, 0));

	CPen pen(PS_DOT, 1, RGB(200, 200, 200));
	CPen *pOldPen = pdc->SelectObject(&pen);

	if (SustainPoint >= 0)
	{
		CPoint p = PS2SS(Handles[SustainPoint]);
		pdc->MoveTo(p.x, 0);
		pdc->LineTo(p.x, rcBounds.bottom);
	}

	CPen pen2(PS_SOLID, 1, RGB(200, 0, 0));
	pdc->SelectObject(&pen2);


	for (PointVector::iterator i = Handles.begin(); i != Handles.end(); i++)
	{
		CPoint p = PS2SS(*i);

		if (i == Handles.begin())
			pdc->MoveTo(p);
		else
			pdc->LineTo(p);
	}

	
	for (i = Handles.begin(); i != Handles.end(); i++)
		DrawHandle(pdc, PS2SS(*i));

	if (LastPlayPos >= 0)
	{
		int p = LastPlayPos;
		LastPlayPos = -1;
		DrawPlayPos(pdc, p);
	}

	if (!IsOptimizedDraw())
	{
		pdc->SelectObject(pOldPen);
	}

}


/////////////////////////////////////////////////////////////////////////////
// CEnvelopeCtrl::DoPropExchange - Persistence support

void CEnvelopeCtrl::DoPropExchange(CPropExchange* pPX)
{
	ExchangeVersion(pPX, MAKELONG(_wVerMinor, _wVerMajor));
	COleControl::DoPropExchange(pPX);

	// TODO: Call PX_ functions for each persistent custom property.

}


/////////////////////////////////////////////////////////////////////////////
// CEnvelopeCtrl::GetControlFlags -
// Flags to customize MFC's implementation of ActiveX controls.
//
// For information on using these flags, please see MFC technical note
// #nnn, "Optimizing an ActiveX Control".
DWORD CEnvelopeCtrl::GetControlFlags()
{
	DWORD dwFlags = COleControl::GetControlFlags();


	// The control will not be redrawn when making the transition
	// between the active and inactivate state.
	dwFlags |= noFlickerActivate;

	// The control can optimize its OnDraw method, by not restoring
	// the original GDI objects in the device context.
	dwFlags |= canOptimizeDraw;
	return dwFlags;
}


/////////////////////////////////////////////////////////////////////////////
// CEnvelopeCtrl::OnResetState - Reset control to default state

void CEnvelopeCtrl::OnResetState()
{
	COleControl::OnResetState();  // Resets defaults found in DoPropExchange

	Reset();
}


/////////////////////////////////////////////////////////////////////////////
// CEnvelopeCtrl message handlers

CPoint CEnvelopeCtrl::PS2SS(CPoint const &p)
{
	CRect &r = Bounds;

	return CPoint(((p.x * (r.right - r.left - HANDLE_SIZE * 2)) >> 16) + HANDLE_SIZE, 
				(((p.y * (r.bottom - r.top - HANDLE_SIZE * 2)) >> 16) + HANDLE_SIZE));
}

CPoint CEnvelopeCtrl::SS2PS(CPoint const &p)
{
	CRect &r = Bounds;

	return CPoint(((p.x - HANDLE_SIZE) << 16) / (r.right - r.left - HANDLE_SIZE * 2),
					((p.y - HANDLE_SIZE) << 16) / (r.bottom - r.top - HANDLE_SIZE * 2));
	
	//	return CPoint(((p.x * (r.right - r.left - HANDLE_SIZE * 2)) >> 16) + HANDLE_SIZE, 
//				(((p.y * (r.bottom - r.top - HANDLE_SIZE * 2)) >> 16) + HANDLE_SIZE));
}


void CEnvelopeCtrl::DrawHandle(CDC * pdc, CPoint const & p)
{
	pdc->FillSolidRect(CRect(p.x - HANDLE_SIZE, p.y - HANDLE_SIZE, p.x + (HANDLE_SIZE+1), p.y + (HANDLE_SIZE+1)), RGB(255, 255, 2555));
}

void CEnvelopeCtrl::OnContextMenu(CWnd*, CPoint point)
{
	// CG: This block was added by the Pop-up Menu component
	{
		if (point.x == -1 && point.y == -1){
			//keystroke invocation
			CRect rect;
			GetClientRect(rect);
			ClientToScreen(rect);

			point = rect.TopLeft();  
			point.Offset(5, 5);
		}

		PopupPoint = point;
		ScreenToClient(&PopupPoint);

		CMenu menu;
		
		int ih = GetHandleAt(PopupPoint);

		if (GetHandleAt(PopupPoint) >= 0)
			VERIFY(menu.LoadMenu(CG_IDR_POPUP_ENVELOPE_CTRL));
		else
			VERIFY(menu.LoadMenu(CG_IDR_POPUP_ENVELOPE_CTRL2));

		CMenu* pPopup = menu.GetSubMenu(0);
		ASSERT(pPopup != NULL);
		CWnd* pWndPopupOwner = this;




		pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, point.x, point.y,
			pWndPopupOwner);
	}
}

// returns index of handle or -1 if p is not on a handle
int CEnvelopeCtrl::GetHandleAt(CPoint const & p)
{
	for (int i = 0; i < Handles.size(); i++)
	{
		CPoint hp = PS2SS(Handles[i]);
		
		if (p.x >= hp.x - HANDLE_SIZE && p.x <= hp.x + HANDLE_SIZE
			&& p.y >= hp.y - HANDLE_SIZE && p.y <= hp.y + HANDLE_SIZE)
			return i;
	}

	return -1;
}

int CEnvelopeCtrl::GetHandleLeftTo(int const x)
{
	ASSERT(x >= 0 && x <= 65535);

	for (int i = 0; i < Handles.size(); i++)
	{
		if (Handles[i].x > x)
			return i - 1;
	}

	ASSERT(false);
	return -1;
}


void CEnvelopeCtrl::ClampHandle(int const i)
{
	int minx = (i > 0) ? Handles[i-1].x + 1 : 0;
	int maxx = (i < Handles.size() - 1) ? Handles[i+1].x - 1 : 65535;

	if (i == 0)
		Handles[i].x = 0;
	else if (i == Handles.size() - 1)
		Handles[i].x = 65535;
	else
		Handles[i].x = min(max(Handles[i].x, minx), maxx);
	
	Handles[i].y = min(max(Handles[i].y, 0), 65535);
}


void CEnvelopeCtrl::OnLButtonDown(UINT nFlags, CPoint point) 
{
	iDragHandle = GetHandleAt(point);
	if (iDragHandle >= 0)
	{
		SetCapture();
	}
	else
	{
		PopupPoint = point;
		OnAddPoint();
	}

	COleControl::OnLButtonDown(nFlags, point);
} 

void CEnvelopeCtrl::OnLButtonUp(UINT nFlags, CPoint point) 
{
	if (iDragHandle >= 0)
	{
		ReleaseCapture();
		EnvChanged();
	}

	iDragHandle = -1;


	COleControl::OnLButtonUp(nFlags, point);
}


void CEnvelopeCtrl::OnMouseMove(UINT nFlags, CPoint point) 
{
	if (iDragHandle >= 0)
	{
		ASSERT(iDragHandle < Handles.size());
		
		CPoint p = SS2PS(point);
		Handles[iDragHandle] = p;

		ClampHandle(iDragHandle);
		
		InvalidateRect(NULL, FALSE);	
	}
	
	COleControl::OnMouseMove(nFlags, point);
}

void CEnvelopeCtrl::OnAddPoint() 
{
	CPoint p = SS2PS(PopupPoint);

	p.x = min(max(p.x, 1), 65534);
	p.y = min(max(p.y, 0), 65535);

	int i = GetHandleLeftTo(p.x);
	ASSERT(i >= 0 && i < Handles.size());
	
	Handles.insert(Handles.begin() + i + 1, p);

	if (SustainPoint >= 0 && SustainPoint > i)
		SustainPoint++;

	EnvChanged();

	InvalidateRect(NULL, FALSE);
}

void CEnvelopeCtrl::OnDeletePoint() 
{
	int ih = GetHandleAt(PopupPoint);
	if (ih <= 0 || ih >= Handles.size() - 1)
		return;
	
	Handles.erase(Handles.begin() + ih);

	if (SustainPoint == ih)
		SustainPoint = -1;
	else if (SustainPoint >= 0 && SustainPoint > ih)
		SustainPoint--;

	EnvChanged();

	InvalidateRect(NULL, FALSE);
}

void CEnvelopeCtrl::OnUpdateDeletePoint(CCmdUI* pCmdUI) 
{
	int ih = GetHandleAt(PopupPoint);
	pCmdUI->Enable(ih > 0 && ih < Handles.size() - 1);
}

void CEnvelopeCtrl::OnSustain() 
{
	int ih = GetHandleAt(PopupPoint);
	if (ih != SustainPoint)
		SustainPoint = ih;
	else
		SustainPoint = -1;

	EnvChanged();

	InvalidateRect(NULL, FALSE);
}

void CEnvelopeCtrl::OnUpdateSustain(CCmdUI* pCmdUI) 
{
	int ih = GetHandleAt(PopupPoint);
	pCmdUI->SetCheck(ih == SustainPoint);
}

void CEnvelopeCtrl::EnvChanged()
{
	FireEnvelopeChanged(Handles.size(), SustainPoint, (long *)&Handles.front());
}

void CEnvelopeCtrl::OnReset() 
{
	Reset();
	EnvChanged();
	InvalidateRect(NULL, FALSE);
}

void CEnvelopeCtrl::Reset()
{
	Handles.clear();
	Handles.push_back(CPoint(0, 0));
	Handles.push_back(CPoint(65535, 65535));

	iDragHandle = -1;
	SustainPoint = -1; 

	LastPlayPos = -1;

	EnvChanged();
}

void CEnvelopeCtrl::SetEnvelope(long numPoints, long sp, long FAR* Points) 
{
	Handles.resize(numPoints);
	SustainPoint = sp;

	for (int i = 0; i < Handles.size(); i++)
	{
		Handles[i].x = *Points++;
		Handles[i].y = *Points++;
	}

	EnvChanged();

	InvalidateRect(NULL, FALSE);
}

void CEnvelopeCtrl::OnInvert() 
{
	for (int i = 0; i < Handles.size(); i++)
		Handles[i].y = 65535 - Handles[i].y;

	EnvChanged();

	InvalidateRect(NULL, FALSE);
}

void CEnvelopeCtrl::SetPlayPosition(long x) 
{
	if (x < 0 || x > 65535)
		x = -1;

	CDC *pDC = GetDC();
	DrawPlayPos(pDC, x);
	ReleaseDC(pDC);
	
}

void CEnvelopeCtrl::DrawPlayPos(CDC * pDC, int const newpos)
{
	if (newpos == LastPlayPos)
		return;

	if (LastPlayPos >= 0)
	{
		CPoint sp = PS2SS(CPoint(LastPlayPos, 0));

		CRect r;
		GetClientRect(r);
		r.left = sp.x;
		r.right = sp.x + 1;

		pDC->InvertRect(r);
	}
	
	if (newpos >= 0)
	{
		CPoint sp = PS2SS(CPoint(newpos, 0));

		CRect r;
		GetClientRect(r);
		r.left = sp.x;
		r.right = sp.x + 1;

		pDC->InvertRect(r);
	
		LastPlayPos = newpos;
	}
}
